FADE_IN_TIME = 2;
DEFAULT_TOOLTIP_COLOR = {0.8, 0.8, 0.8, 0.09, 0.09, 0.09};

function AccountLogin_OnLoad()
	this:SetSequence(0);
	this:SetCamera(0);
	
	TOSFrame.isTOS = nil;

	this:RegisterEvent("SHOW_SERVER_ALERT");

	local versionType, buildType, version, internalVersion, date = GetBuildInfo();
	AccountLoginVersion:SetText(format(TEXT(VERSION_TEMPLATE), versionType, version, internalVersion, buildType, date));

	-- Color edit box backdrops
	local backdropColor = DEFAULT_TOOLTIP_COLOR;
	AccountLoginAccountEdit:SetBackdropBorderColor(backdropColor[1], backdropColor[2], backdropColor[3]);
	AccountLoginAccountEdit:SetBackdropColor(backdropColor[4], backdropColor[5], backdropColor[6]);
	AccountLoginPasswordEdit:SetBackdropBorderColor(backdropColor[1], backdropColor[2], backdropColor[3]);
	AccountLoginPasswordEdit:SetBackdropColor(backdropColor[4], backdropColor[5], backdropColor[6]);
end

function AccountLogin_OnShow()
	CurrentGlueMusic = "Sound\\Music\\GlueScreenMusic\\wow_main_theme.mp3";

	-- Check the interface version
	if ( GetDataInterface() ~= GetCodeInterface() ) then
		DeleteInterface();
	end

	-- Try to show the EULA or the TOS
	AccountLogin_ShowUserAgreements();
	
	local accountName = GetLastAccountName();
	local serverName = GetServerName();
	if(serverName) then
		AccountLoginRealmName:SetText(serverName);
	else
		AccountLoginRealmName:Hide()
	end
	
	if ( accountName and strlen(accountName) > 0 ) then
		AccountLoginAccountEdit:SetText(string.lower(accountName));
		AccountLoginPasswordEdit:SetFocus();
	else
		AccountLoginAccountEdit:SetText("");
		AccountLoginAccountEdit:SetFocus();
	end
	-- EDIT HERE EDIT HERE EDIT HERE EDIT HERE
	-- Capnbry:  I take no credit for this script, it comes directly from
	-- the distributed game files.
	-- Uncomment the following line to have your password fill in automatically
	-- Of course, also put your password in quotes 
	--AccountLoginPasswordEdit:SetText("mypassword");
end

function AccountLogin_FocusPassword()
	AccountLoginPasswordEdit:SetFocus("");
end

function AccountLogin_FocusAccountName()
	AccountLoginAccountEdit:SetFocus("");
end

function AccountLogin_OnChar()
end

function AccountLogin_OnKeyDown()
	if ( arg1 == "ESCAPE" ) then
		AccountLogin_Exit();
	elseif ( arg1 == "ENTER" ) then
		if ( not TOSAccepted() ) then
			return;
		elseif ( TOSFrame:IsVisible() or ConnectionHelpFrame:IsVisible() ) then
			return;
		end
		AccountLogin_Login();
	elseif ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
	end
end

function AccountLogin_OnEvent(event)
	if ( event == "SHOW_SERVER_ALERT" ) then
		ServerAlertText:SetText(arg1);
		ServerAlertFrame:Show();
	end
end

function AccountLogin_Login()
	PlaySound("gsLogin");
	DefaultServerLogin(AccountLoginAccountEdit:GetText(), AccountLoginPasswordEdit:GetText());
	AccountLoginPasswordEdit:SetText("");
	
end

function AccountLogin_ManageAccount()
	PlaySound("gsLoginNewAccount");
	LaunchURL(AUTH_NO_TIME_URL);
end

function AccountLogin_LaunchCommunitySite()
	PlaySound("gsLoginNewAccount");
	LaunchURL(COMMUNITY_URL);
end

function AccountLogin_Credits()
	if ( not GlueDialog:IsVisible() ) then
		PlaySound("gsTitleCredits");
		SetGlueScreen("credits");
	end
end

function AccountLogin_Cinematics()
	if ( not GlueDialog:IsVisible() ) then
		PlaySound("gsTitleIntroMovie");
		SetGlueScreen("movie");
	end
end

function AccountLogin_Options()
	PlaySound("gsTitleOptions");
end

function AccountLogin_Exit()
	PlaySound("gsTitleQuit");
	QuitGame();
end

function AccountLogin_ShowUserAgreements()
	if ( not EULAAccepted() ) then
		if ( ShowEULANotice() ) then
			TOSNotice:SetText(EULA_NOTICE);
			TOSNotice:Show();
		end
		AccountLoginUI:Hide();
		TOSFrame.isTOS = nil;
		TOSFrameTitle:SetText(EULA_FRAME_TITLE);
		TOSFrameHeader:SetWidth(TOSFrameTitle:GetWidth() + 310);
		TOSScrollFrame:Hide();
		EULAScrollFrame:Show();
		TOSText:Hide();
		EULAText:Show();
		TOSFrame:Show();
	elseif ( not TOSAccepted() ) then
		if ( ShowTOSNotice() ) then
			TOSNotice:SetText(TOS_NOTICE);
			TOSNotice:Show();
		end
		AccountLoginUI:Hide();
		TOSFrame.isTOS = 1;
		TOSFrameTitle:SetText(TOS_FRAME_TITLE);
		TOSFrameHeader:SetWidth(TOSFrameTitle:GetWidth() + 310);
		TOSScrollFrame:Show();
		EULAScrollFrame:Hide();
		TOSText:Show();
		EULAText:Hide();
		TOSFrame:Show();
	else
		AccountLoginUI:Show();
		EULAScrollFrame:Hide();
		TOSFrame:Hide();
	end
end
